(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40234,        997]*)
(*NotebookOutlinePosition[     40888,       1020]*)
(*  CellTagsIndexPosition[     40844,       1016]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(A = 
      Plot[4.1 + 0.5  Cot[x] - 1.1  Csc[x], {x, 0.35, 2.3}, 
        AspectRatio \[Rule] Automatic, PlotStyle \[Rule] {Thickness[0.004]}, 
        PlotRange -> {1.67, 3.5}, AxesOrigin \[Rule] {0.2, 2}, 
        Ticks \[Rule] None, AxesStyle \[Rule] {Thickness[0.003]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .75776 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.414079 -0.691511 0.414079 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .75926 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .13665 m
1 .13665 L
s
.10663 0 m
.10663 .75776 L
s
0 0 m
1 0 L
1 .75776 L
0 .75776 L
closepath
clip
newpath
.004 w
.16874 .24505 m
.18468 .30962 L
.20149 .36395 L
.21999 .41168 L
.23722 .44756 L
.26948 .49855 L
.28679 .51938 L
.30254 .53526 L
.32014 .55013 L
.33639 .56154 L
.36896 .57896 L
.38484 .58523 L
.40233 .5907 L
.41878 .59463 L
.43648 .59766 L
.44505 .59872 L
.44958 .59917 L
.4544 .59958 L
.45903 .5999 L
.46323 .60013 L
.46526 .60022 L
.46746 .6003 L
.46954 .60037 L
.47143 .60042 L
.47344 .60045 L
.47455 .60047 L
.4756 .60048 L
.47657 .60049 L
.47746 .6005 L
.47845 .6005 L
.47949 .6005 L
.48054 .60049 L
.48112 .60049 L
.48166 .60049 L
.48265 .60048 L
.4837 .60046 L
.48591 .60042 L
.48834 .60037 L
.49281 .60021 L
.49759 .59999 L
.5062 .59942 L
.51488 .59864 L
.52429 .59757 L
.54138 .59504 L
.55823 .59182 L
.57607 .58764 L
.60819 .57818 L
.64239 .56533 L
.67531 .55019 L
.71031 .53091 L
Mistroke
.74402 .50896 L
.77644 .48433 L
.81095 .45377 L
.84417 .41941 L
.87946 .3765 L
.91348 .32749 L
.94621 .27145 L
.97619 .21041 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{224.75, 170.313},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003P0000ZQ000`40O003h00Oh7oo000HOol00`00
Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool0
01Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001o
ogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`00
67oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007oo
Ool0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000H
Ool00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomo
o`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qo
o`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo
0<Eoo`0067oo00<007ooOol0aGoo003P000001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo
000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00
Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool0
01Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001o
ogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0;ioo`03
001oogoo00Aoo`0067oo00<007ooOol0_Woo00<007ooOol017oo000HOol00`00Oomoo`2mOol00`00
Oomoo`05Ool001Qoo`03001oogoo0;eoo`03001oogoo00Eoo`0067oo00<007ooOol0_7oo00<007oo
Ool01Woo000HOol00`00Oomoo`2lOol00`00Oomoo`06Ool001Qoo`03001oogoo0;]oo`03001oogoo
00Moo`0067oo00<007ooOol0^goo00<007ooOol01goo000HOol00`00Oomoo`0;Ool00`00Oomoo`2]
Ool00`00Oomoo`07Ool001Qoo`03001oogoo00]oo`03001oogoo0:aoo`03001oogoo00Qoo`0067oo
00<007ooOol02goo00<007ooOol0[7oo00<007ooOol027oo000HOol00`00Oomoo`0<Ool00`00Oomo
o`2ZOol00`00Oomoo`09Ool001Qoo`03001oogoo00aoo`03001oogoo0:Yoo`03001oogoo00Uoo`00
67oo00<007ooOol037oo00<007ooOol0ZGoo00<007ooOol02Woo000HOol00`00Oomoo`0<Ool00`00
Oomoo`2YOol00`00Oomoo`0:Ool001Qoo`03001oogoo00aoo`03001oogoo0:Qoo`03001oogoo00]o
o`0067oo00<007ooOol03Goo00<007ooOol0Ygoo00<007ooOol02goo000HOol00`00Oomoo`0=Ool0
0`00Oomoo`2VOol00`00Oomoo`0<Ool001Qoo`03001oogoo00eoo`03001oogoo0:Eoo`03001oogoo
00eoo`0067oo00<007ooOol03Goo00<007ooOol0YGoo00<007ooOol03Goo000HOol00`00Oomoo`0>
Ool00`00Oomoo`2SOol00`00Oomoo`0>Ool001Qoo`03001oogoo00ioo`03001oogoo0:9oo`03001o
ogoo00moo`0067oo00<007ooOol03Woo00<007ooOol0XWoo00<007ooOol03goo000HOol00`00Oomo
o`0>Ool00`00Oomoo`2QOol00`00Oomoo`0@Ool001Qoo`03001oogoo00moo`03001oogoo09moo`03
001oogoo015oo`0067oo00<007ooOol03goo00<007ooOol0Wgoo00<007ooOol04Goo000HOol00`00
Oomoo`0?Ool00`00Oomoo`2NOol00`00Oomoo`0BOol001Qoo`03001oogoo011oo`03001oogoo09ao
o`03001oogoo01=oo`0067oo00<007ooOol047oo00<007ooOol0W7oo00<007ooOol04goo000HOol0
0`00Oomoo`0@Ool00`00Oomoo`2KOol00`00Oomoo`0DOol001Qoo`03001oogoo011oo`03001oogoo
09Yoo`03001oogoo01Eoo`0067oo00<007ooOol04Goo00<007ooOol0VGoo00<007ooOol05Goo000H
Ool00`00Oomoo`0AOol00`00Oomoo`2HOol00`00Oomoo`0FOol001Qoo`03001oogoo015oo`03001o
ogoo09Qoo`03001oogoo01Ioo`0067oo00<007ooOol04Woo00<007ooOol0UWoo00<007ooOol05goo
000HOol00`00Oomoo`0BOol00`00Oomoo`2EOol00`00Oomoo`0HOol001Qoo`03001oogoo019oo`03
001oogoo09Eoo`03001oogoo01Qoo`0067oo00<007ooOol04goo00<007ooOol0Tgoo00<007ooOol0
6Goo000HOol00`00Oomoo`0COol00`00Oomoo`2BOol00`00Oomoo`0JOol001Qoo`03001oogoo01Ao
o`03001oogoo091oo`03001oogoo01]oo`0067oo00<007ooOol057oo00<007ooOol0T7oo00<007oo
Ool06goo000HOol00`00Oomoo`0DOol00`00Oomoo`2?Ool00`00Oomoo`0LOol001Qoo`03001oogoo
01Eoo`03001oogoo08eoo`03001oogoo01eoo`0067oo00<007ooOol05Goo00<007ooOol0S7oo00<0
07ooOol07Woo000HOol00`00Oomoo`0FOol00`00Oomoo`2:Ool00`00Oomoo`0OOol001Qoo`03001o
ogoo01Ioo`03001oogoo08Yoo`03001oogoo01moo`0067oo00<007ooOol05goo00<007ooOol0R7oo
00<007ooOol087oo000HOol00`00Oomoo`0GOol00`00Oomoo`27Ool00`00Oomoo`0QOol001Qoo`03
001oogoo01Qoo`03001oogoo08Eoo`03001oogoo029oo`0067oo00<007ooOol067oo00<007ooOol0
Q7oo00<007ooOol08goo000HOol00`00Oomoo`0IOol00`00Oomoo`22Ool00`00Oomoo`0TOol001Qo
o`03001oogoo01Uoo`03001oogoo089oo`03001oogoo02Aoo`0067oo00<007ooOol06Woo00<007oo
Ool0P7oo00<007ooOol09Goo000HOol00`00Oomoo`0JOol00`00Oomoo`1oOol00`00Oomoo`0VOol0
01Qoo`03001oogoo01]oo`03001oogoo07eoo`03001oogoo02Moo`0067oo00<007ooOol06goo00<0
07ooOol0O7oo00<007ooOol0:7oo000HOol00`00Oomoo`0LOol00`00Oomoo`1jOol00`00Oomoo`0Y
Ool001Qoo`03001oogoo01eoo`03001oogoo07Moo`8002aoo`0067oo00<007ooOol07Goo00<007oo
Ool0MWoo00<007ooOol0;7oo000HOol00`00Oomoo`0NOol00`00Oomoo`1dOol00`00Oomoo`0]Ool0
01Qoo`03001oogoo01ioo`03001oogoo079oo`80031oo`0067oo00<007ooOol07goo00<007ooOol0
L7oo00<007ooOol0<7oo000HOol00`00Oomoo`0POol00`00Oomoo`1^Ool00`00Oomoo`0aOol001Qo
o`03001oogoo021oo`03001oogoo06eoo`03001oogoo039oo`0067oo00<007ooOol08Goo00<007oo
Ool0JWoo0P00=Goo000HOol00`00Oomoo`0ROol00`00Oomoo`1XOol00`00Oomoo`0eOol001Qoo`03
001oogoo02=oo`03001oogoo06Ioo`03001oogoo03Ioo`0067oo00<007ooOol08goo00<007ooOol0
IGoo00<007ooOol0=goo000HOol00`00Oomoo`0TOol00`00Oomoo`1ROol2000jOol001Qoo`03001o
ogoo02Eoo`03001oogoo061oo`03001oogoo03Yoo`0067oo00<007ooOol09Woo00<007ooOol0GGoo
0P00?Goo000HOol00`00Oomoo`0WOol00`00Oomoo`1JOol2000oOol001Qoo`03001oogoo02Moo`03
001oogoo05Qoo`80045oo`0067oo00<007ooOol0:7oo00<007ooOol0EGoo0P00@goo000HOol00`00
Oomoo`0YOol2001COol20015Ool001Qoo`03001oogoo02]oo`03001oogoo04ioo`8004Moo`0067oo
00<007ooOol0;7oo0P00C7oo0P00BGoo000HOol00`00Oomoo`0^Ool20018Ool2001;Ool001Qoo`03
001oogoo031oo`03001oogoo04=oo`8004eoo`0067oo00<007ooOol0<Goo0P00@7oo0`00Cgoo000H
Ool00`00Oomoo`0cOol2000lOol2001BOol001Qoo`03001oogoo03Eoo`8003Moo`<005Aoo`0067oo
00<007ooOol0=goo0P00<Woo0`00Egoo000HOol00`00Oomoo`0iOol2000/Ool4001JOol001Qoo`03
001oogoo03]oo`<002Eoo`@005ioo`0067oo00<007ooOol0?Woo0`007goo0`00HWoo000HOol00`00
Oomoo`11Ool4000GOol4001UOol001Qoo`03001oogoo04EooaL006Uoo`0067oo00<007ooOol0aGoo
000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00
Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool0
01Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001o
ogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`00
67oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007oo
Ool0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000H
Ool00`00Oomoo`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomo
o`35Ool001Qoo`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qo
o`03001oogoo0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool001Qoo`03001oogoo
0<Eoo`0067oo00<007ooOol0aGoo000HOol00`00Oomoo`35Ool00001\
\>"],
  ImageRangeCache->{{{0, 223.75}, {169.313, 0}} -> {-0.0639845, 1.66637, \
0.0108513, 0.0108513}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(K = {Text[a1, {0.4, 1.75}]}\)], "Input"],

Cell[BoxData[
    \({Text[a1, {0.4`, 1.75`}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[K]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .75776 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.414079 -0.691511 0.414079 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .75926 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .13665 m
1 .13665 L
s
.10663 0 m
.10663 .75776 L
s
0 0 m
1 0 L
1 .75776 L
0 .75776 L
closepath
clip
newpath
.004 w
.16874 .24505 m
.18468 .30962 L
.20149 .36395 L
.21999 .41168 L
.23722 .44756 L
.26948 .49855 L
.28679 .51938 L
.30254 .53526 L
.32014 .55013 L
.33639 .56154 L
.36896 .57896 L
.38484 .58523 L
.40233 .5907 L
.41878 .59463 L
.43648 .59766 L
.44505 .59872 L
.44958 .59917 L
.4544 .59958 L
.45903 .5999 L
.46323 .60013 L
.46526 .60022 L
.46746 .6003 L
.46954 .60037 L
.47143 .60042 L
.47344 .60045 L
.47455 .60047 L
.4756 .60048 L
.47657 .60049 L
.47746 .6005 L
.47845 .6005 L
.47949 .6005 L
.48054 .60049 L
.48112 .60049 L
.48166 .60049 L
.48265 .60048 L
.4837 .60046 L
.48591 .60042 L
.48834 .60037 L
.49281 .60021 L
.49759 .59999 L
.5062 .59942 L
.51488 .59864 L
.52429 .59757 L
.54138 .59504 L
.55823 .59182 L
.57607 .58764 L
.60819 .57818 L
.64239 .56533 L
.67531 .55019 L
.71031 .53091 L
Mistroke
.74402 .50896 L
.77644 .48433 L
.81095 .45377 L
.84417 .41941 L
.87946 .3765 L
.91348 .32749 L
.94621 .27145 L
.97619 .21041 L
Mfstroke
gsave
.18944 .03313 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{234.625, 177.75},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003Z0000/A000`40O003h00O6Goo00<007ooOol0
cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol0
0`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol02goo1@0000=oo`0000000`00
^7oo000IOol00`00Oomoo`0;Ool40004Ool00`00Oomoo`2hOol001Uoo`03001oogoo00ioo`03001o
ogoo009oo`03001oogoo0;Qoo`006Goo00<007ooOol037oo0`0017oo00<007ooOol0^7oo000IOol0
0`00Oomoo`0COol00`00Oomoo`2hOol001Uoo`03001oogoo019oo`800;Yoo`006Goo00<007ooOol0
cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol0
0`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>
Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03
001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<io
o`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<0
07ooOol0cWoo000IOol00`00Oomoo`3>Ool00>T0005oo`006Goo00<007ooOol0cWoo000IOol00`00
Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool0
01Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001o
ogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`00
6Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007oo
Ool0cWoo000IOol00`00Oomoo`37Ool00`00Oomoo`04Ool001Uoo`03001oogoo0<Moo`03001oogoo
00Aoo`006Goo00<007ooOol0aWoo00<007ooOol01Goo000IOol00`00Oomoo`36Ool00`00Oomoo`05
Ool001Uoo`03001oogoo0<Eoo`03001oogoo00Ioo`006Goo00<007ooOol0aGoo00<007ooOol01Woo
000IOol00`00Oomoo`34Ool00`00Oomoo`07Ool001Uoo`03001oogoo0<Aoo`03001oogoo00Moo`00
6Goo00<007ooOol02goo00<007ooOol0]Goo00<007ooOol027oo000IOol00`00Oomoo`0;Ool00`00
Oomoo`2eOol00`00Oomoo`08Ool001Uoo`03001oogoo00aoo`03001oogoo0;=oo`03001oogoo00Uo
o`006Goo00<007ooOol037oo00<007ooOol0/goo00<007ooOol02Goo000IOol00`00Oomoo`0<Ool0
0`00Oomoo`2bOol00`00Oomoo`0:Ool001Uoo`03001oogoo00aoo`03001oogoo0;9oo`03001oogoo
00Yoo`006Goo00<007ooOol03Goo00<007ooOol0/7oo00<007ooOol02goo000IOol00`00Oomoo`0=
Ool00`00Oomoo`2_Ool00`00Oomoo`0<Ool001Uoo`03001oogoo00eoo`03001oogoo0:moo`03001o
ogoo00aoo`006Goo00<007ooOol03Goo00<007ooOol0[Woo00<007ooOol03Goo000IOol00`00Oomo
o`0>Ool00`00Oomoo`2]Ool00`00Oomoo`0=Ool001Uoo`03001oogoo00ioo`03001oogoo0:aoo`03
001oogoo00ioo`006Goo00<007ooOol03Woo00<007ooOol0Zgoo00<007ooOol03goo000IOol00`00
Oomoo`0>Ool00`00Oomoo`2[Ool00`00Oomoo`0?Ool001Uoo`03001oogoo00moo`03001oogoo0:Uo
o`03001oogoo011oo`006Goo00<007ooOol03goo00<007ooOol0Z7oo00<007ooOol04Goo000IOol0
0`00Oomoo`0?Ool00`00Oomoo`2XOol00`00Oomoo`0AOol001Uoo`03001oogoo011oo`03001oogoo
0:Ioo`03001oogoo019oo`006Goo00<007ooOol047oo00<007ooOol0YWoo00<007ooOol04Woo000I
Ool00`00Oomoo`0@Ool00`00Oomoo`2UOol00`00Oomoo`0COol001Uoo`03001oogoo015oo`03001o
ogoo0:=oo`03001oogoo01Aoo`006Goo00<007ooOol04Goo00<007ooOol0Xgoo00<007ooOol057oo
000IOol00`00Oomoo`0AOol00`00Oomoo`2ROol00`00Oomoo`0EOol001Uoo`03001oogoo015oo`03
001oogoo0:5oo`03001oogoo01Ioo`006Goo00<007ooOol04Woo00<007ooOol0X7oo00<007ooOol0
5Woo000IOol00`00Oomoo`0BOol00`00Oomoo`2OOol00`00Oomoo`0GOol001Uoo`03001oogoo019o
o`03001oogoo09ioo`03001oogoo01Qoo`006Goo00<007ooOol04goo00<007ooOol0WGoo00<007oo
Ool067oo000IOol00`00Oomoo`0COol00`00Oomoo`2LOol00`00Oomoo`0IOol001Uoo`03001oogoo
01=oo`03001oogoo09]oo`03001oogoo01Yoo`006Goo00<007ooOol057oo00<007ooOol0VWoo00<0
07ooOol06Woo000IOol00`00Oomoo`0DOol00`00Oomoo`2IOol00`00Oomoo`0KOol001Uoo`03001o
ogoo01Aoo`03001oogoo09Qoo`03001oogoo01aoo`006Goo00<007ooOol05Goo00<007ooOol0UWoo
00<007ooOol07Goo000IOol00`00Oomoo`0EOol00`00Oomoo`2FOol00`00Oomoo`0MOol001Uoo`03
001oogoo01Ioo`03001oogoo09Aoo`03001oogoo01ioo`006Goo00<007ooOol05Woo00<007ooOol0
Tgoo00<007ooOol07goo000IOol00`00Oomoo`0FOol00`00Oomoo`2BOol00`00Oomoo`0POol001Uo
o`03001oogoo01Moo`03001oogoo091oo`03001oogoo025oo`006Goo00<007ooOol05goo00<007oo
Ool0T7oo00<007ooOol08Goo000IOol00`00Oomoo`0HOol00`00Oomoo`2>Ool00`00Oomoo`0ROol0
01Uoo`03001oogoo01Qoo`03001oogoo08eoo`03001oogoo02=oo`006Goo00<007ooOol06Goo00<0
07ooOol0Rgoo00<007ooOol097oo000IOol00`00Oomoo`0IOol00`00Oomoo`2:Ool00`00Oomoo`0U
Ool001Uoo`03001oogoo01Yoo`03001oogoo08Qoo`03001oogoo02Ioo`006Goo00<007ooOol06Woo
00<007ooOol0R7oo00<007ooOol09Woo000IOol00`00Oomoo`0KOol00`00Oomoo`26Ool00`00Oomo
o`0WOol001Uoo`03001oogoo01]oo`03001oogoo08Eoo`03001oogoo02Qoo`006Goo00<007ooOol0
77oo00<007ooOol0Pgoo00<007ooOol0:Goo000IOol00`00Oomoo`0LOol00`00Oomoo`22Ool00`00
Oomoo`0ZOol001Uoo`03001oogoo01eoo`03001oogoo081oo`03001oogoo02]oo`006Goo00<007oo
Ool07Woo00<007ooOol0OWoo00<007ooOol0;7oo000IOol00`00Oomoo`0NOol00`00Oomoo`1mOol0
0`00Oomoo`0]Ool001Uoo`03001oogoo01moo`03001oogoo07Yoo`80031oo`006Goo00<007ooOol0
87oo00<007ooOol0N7oo00<007ooOol0<7oo000IOol00`00Oomoo`0POol00`00Oomoo`1gOol00`00
Oomoo`0aOol001Uoo`03001oogoo025oo`03001oogoo07Eoo`03001oogoo039oo`006Goo00<007oo
Ool08Woo00<007ooOol0LWoo0P00=Goo000IOol00`00Oomoo`0ROol00`00Oomoo`1aOol00`00Oomo
o`0eOol001Uoo`03001oogoo02=oo`03001oogoo06ioo`8003Qoo`006Goo00<007ooOol097oo00<0
07ooOol0Jgoo0P00>Woo000IOol00`00Oomoo`0UOol00`00Oomoo`1YOol00`00Oomoo`0jOol001Uo
o`03001oogoo02Eoo`03001oogoo06Moo`8003eoo`006Goo00<007ooOol09Woo00<007ooOol0IGoo
00<007ooOol0?Goo000IOol00`00Oomoo`0WOol00`00Oomoo`1ROol20010Ool001Uoo`03001oogoo
02Qoo`03001oogoo05moo`80049oo`006Goo00<007ooOol0:Goo00<007ooOol0GGoo00<007ooOol0
@Woo000IOol00`00Oomoo`0ZOol00`00Oomoo`1JOol20015Ool001Uoo`03001oogoo02]oo`03001o
ogoo05Qoo`03001oogoo04Eoo`006Goo00<007ooOol0;7oo0P00EWoo0P00B7oo000IOol00`00Oomo
o`0^Ool00`00Oomoo`1AOol2001:Ool001Uoo`03001oogoo02moo`03001oogoo04ioo`8004aoo`00
6Goo00<007ooOol0<7oo00<007ooOol0Bgoo0P00CWoo000IOol00`00Oomoo`0aOol00`00Oomoo`17
Ool3001@Ool001Uoo`03001oogoo039oo`8004Aoo`<005=oo`006Goo00<007ooOol0=7oo0P00@7oo
0P00EWoo000IOol00`00Oomoo`0fOol2000kOol3001HOol001Uoo`03001oogoo03Qoo`8003Ioo`<0
05]oo`006Goo00<007ooOol0>Woo0`00<Goo0P00GWoo000IOol00`00Oomoo`0mOol4000[Ool2001P
Ool001Uoo`03001oogoo045oo`<002Aoo`@0069oo`006Goo00<007ooOol0A7oo100067oo2000IWoo
000IOol00`00Oomoo`18Ool80008Ool8001^Ool001Uoo`03001oogoo051oo`P007Ioo`006Goo00<0
07ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo
000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00
Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool0
01Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001o
ogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`00
6Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007oo
Ool0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000I
Ool00`00Oomoo`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomo
o`3>Ool001Uoo`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uo
o`03001oogoo0<ioo`006Goo00<007ooOol0cWoo000IOol00`00Oomoo`3>Ool001Uoo`03001oogoo
0<ioo`00\
\>"],
  ImageRangeCache->{{{0, 233.625}, {176.75, 0}} -> {-0.0642245, 1.66637, \
0.0103946, 0.0103946}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<concava.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(G = 
      Plot[0.6 + Cosh[x], {x, \(-1\), 1.5}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Thickness[0.003]}, Ticks \[Rule] None, 
        PlotRange \[Rule] {1.1, 3}, AxesOrigin \[Rule] {\(-0.8\), 1.4}, 
        AxesStyle \[Rule] {Thickness[0.003]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .72381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.380952 -0.419048 0.380952 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .72531 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .11429 m
1 .11429 L
s
.1 0 m
.1 .72381 L
s
0 0 m
1 0 L
1 .72381 L
0 .72381 L
closepath
clip
newpath
.02381 .39736 m
.06244 .35491 L
.10458 .31499 L
.14415 .28315 L
.18221 .25735 L
.22272 .23481 L
.26171 .21765 L
.28158 .21056 L
.30316 .20411 L
.32216 .19947 L
.34309 .19548 L
.35264 .19405 L
.36292 .19278 L
.37378 .19174 L
.37905 .19134 L
.38395 .19104 L
.38884 .19081 L
.39135 .19071 L
.39406 .19063 L
.39561 .19059 L
.39703 .19055 L
.39837 .19053 L
.39984 .19051 L
.40116 .19049 L
.40239 .19048 L
.40369 .19048 L
.40442 .19048 L
.40509 .19048 L
.40633 .19048 L
.40765 .19049 L
.40878 .1905 L
.41003 .19051 L
.41136 .19053 L
.4128 .19056 L
.4154 .19062 L
.4205 .1908 L
.42518 .19102 L
.43498 .19168 L
.4441 .19251 L
.45411 .19368 L
.4648 .19522 L
.48615 .1992 L
.5063 .20409 L
.54476 .21649 L
.58568 .23425 L
.62509 .25598 L
.66297 .28139 L
.70331 .31357 L
.74214 .34989 L
.78341 .39467 L
Mistroke
.82317 .4443 L
.86142 .49857 L
.90212 .56396 L
.9413 .63504 L
.97619 .70568 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 208.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000d1000`40O003h00O7Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0
ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`00o`0080000Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007ooOol0ogoo0Goo000M
Ool00`00Oomoo`1:OolG002OOol001eoo`03001oogoo03moo`/001Moo`P009Moo`007Goo00<007oo
Ool0>goo1000:Woo1000Tgoo000MOol00`00Oomoo`0iOol2000bOol3002@Ool001eoo`03001oogoo
03Ioo`<003Moo`<008eoo`007Goo00<007ooOol0<goo0`00?Goo1000RGoo000MOol00`00Oomoo`0`
Ool30014Ool40025Ool001eoo`03001oogoo02eoo`<004]oo`<0089oo`007Goo00<007ooOol0:Woo
0`00DGoo0P00P7oo000MOol00`00Oomoo`0XOol2001FOol2001nOol001eoo`03001oogoo02Ioo`80
05Yoo`8007aoo`007Goo00<007ooOol097oo0P00GWoo0P00NWoo000MOol00`00Oomoo`0ROol2001R
Ool2001hOol001eoo`03001oogoo01moo`<006Ioo`8007Ioo`007Goo00<007ooOol07Goo0P00Jgoo
0P00M7oo000MOol00`00Oomoo`0KOol2001_Ool00`00Oomoo`1aOol001eoo`03001oogoo01Uoo`80
079oo`80075oo`007Goo00<007ooOol05goo0P00MWoo0P00Kgoo000MOol00`00Oomoo`0EOol2001j
Ool2001]Ool001eoo`03001oogoo01Aoo`03001oogoo07aoo`03001oogoo06Yoo`007Goo00<007oo
Ool04Woo0P00P7oo0P00JWoo000MOol00`00Oomoo`0AOol00`00Oomoo`22Ool00`00Oomoo`1WOol0
01eoo`03001oogoo00moo`8008Ioo`8006Moo`007Goo00<007ooOol03Goo0P00RWoo0P00IGoo000M
Ool00`00Oomoo`0<Ool00`00Oomoo`2<Ool00`00Oomoo`1ROol001eoo`03001oogoo00Yoo`80091o
o`80069oo`007Goo00<007ooOol02Goo00<007ooOol0TWoo00<007ooOol0Ggoo000MOol00`00Oomo
o`08Ool00`00Oomoo`2DOol00`00Oomoo`1NOol001eoo`03001oogoo00Ioo`8009Qoo`8005ioo`00
7Goo00<007ooOol01Goo00<007ooOol0VWoo00<007ooOol0Fgoo000MOol00`00Oomoo`04Ool00`00
Oomoo`2LOol00`00Oomoo`1JOol001eoo`03001oogoo00=oo`03001oogoo09ioo`03001oogoo05Uo
o`007Goo00<007ooOol00Woo00<007ooOol0X7oo00<007ooOol0F7oo000MOol00`00Oomoo`02002T
Ool2001HOol001eoo`03001oo`000:Qoo`03001oogoo05Eoo`007Goo0P00ZWoo00<007ooOol0E7oo
000MOol00`00Oomoo`2ZOol00`00Oomoo`1COol001aoo`800:eoo`03001oogoo059oo`006goo00<0
07oo0000[Woo00<007ooOol0DGoo000JOol01000Oomoo`00[goo00<007ooOol0D7oo000IOol01@00
Oomoogoo0000/7oo0P00D7oo000HOol00`00Oomoo`02Ool00`00Oomoo`2`Ool00`00Oomoo`1=Ool0
01Moo`03001oogoo00=oo`03001oogoo0;5oo`03001oogoo04aoo`005Woo00<007ooOol017oo00<0
07ooOol0/Woo00<007ooOol0Bgoo000EOol00`00Oomoo`05Ool00`00Oomoo`2cOol00`00Oomoo`1:
Ool001Aoo`03001oogoo00Ioo`03001oogoo0;Aoo`03001oogoo04Uoo`004goo00<007ooOol01goo
00<007ooOol0]Goo00<007ooOol0B7oo000BOol00`00Oomoo`08Ool00`00Oomoo`2fOol00`00Oomo
o`17Ool0015oo`03001oogoo00Uoo`03001oogoo0;Moo`03001oogoo04Ioo`0047oo00<007ooOol0
2Woo00<007ooOol0^7oo00<007ooOol0AGoo000?Ool00`00Oomoo`0;Ool00`00Oomoo`2iOol00`00
Oomoo`14Ool000ioo`03001oogoo00aoo`03001oogoo0;Yoo`03001oogoo04=oo`003Goo00<007oo
Ool03Goo00<007ooOol0^Woo00<007ooOol0@goo000=Ool00`00Oomoo`0=Ool00`00Oomoo`2kOol0
0`00Oomoo`12Ool000aoo`03001oogoo00ioo`03001oogoo0;aoo`03001oogoo045oo`002goo00<0
07ooOol03goo00<007ooOol0_Goo00<007ooOol0@7oo000:Ool00`00Oomoo`0@Ool00`00Oomoo`2n
Ool00`00Oomoo`0oOol000Uoo`03001oogoo015oo`03001oogoo0;moo`03001oogoo03ioo`0027oo
00<007ooOol04Woo00<007ooOol0`7oo00<007ooOol0?Goo0007Ool00`00Oomoo`0COol00`00Oomo
o`31Ool00`00Oomoo`0lOol001eoo`03001oogoo0<9oo`03001oogoo03]oo`007Goo00<007ooOol0
`Woo00<007ooOol0>goo000MOol00`00Oomoo`33Ool00`00Oomoo`0jOol001eoo`03001oogoo0<Ao
o`03001oogoo03Uoo`007Goo00<007ooOol0aGoo00<007ooOol0>7oo000MOol00`00Oomoo`35Ool0
0`00Oomoo`0hOol001eoo`03001oogoo0<Ioo`03001oogoo03Moo`007Goo00<007ooOol0agoo00<0
07ooOol0=Woo000MOol00`00Oomoo`38Ool00`00Oomoo`0eOol001eoo`03001oogoo0<Uoo`03001o
ogoo03Aoo`007Goo00<007ooOol0bGoo00<007ooOol0=7oo000MOol00`00Oomoo`3:Ool00`00Oomo
o`0cOol001eoo`03001oogoo0<]oo`03001oogoo039oo`007Goo00<007ooOol0c7oo00<007ooOol0
<Goo000MOol00`00Oomoo`3<Ool00`00Oomoo`0aOol001eoo`03001oogoo0<eoo`03001oogoo031o
o`007Goo00<007ooOol0cWoo00<007ooOol0;goo000MOol00`00Oomoo`3>Ool00`00Oomoo`0_Ool0
01eoo`03001oogoo0<moo`03001oogoo02ioo`007Goo00<007ooOol0d7oo00<007ooOol0;Goo000M
Ool00`00Oomoo`3AOol00`00Oomoo`0/Ool001eoo`03001oogoo0=5oo`03001oogoo02aoo`007Goo
00<007ooOol0dWoo00<007ooOol0:goo000MOol00`00Oomoo`3COol00`00Oomoo`0ZOol001eoo`03
001oogoo0==oo`03001oogoo02Yoo`007Goo00<007ooOol0e7oo00<007ooOol0:Goo000MOol00`00
Oomoo`3EOol00`00Oomoo`0XOol001eoo`03001oogoo0=Eoo`03001oogoo02Qoo`007Goo00<007oo
Ool0eWoo00<007ooOol09goo000MOol00`00Oomoo`3GOol00`00Oomoo`0VOol001eoo`03001oogoo
0=Moo`03001oogoo02Ioo`007Goo00<007ooOol0f7oo00<007ooOol09Goo000MOol00`00Oomoo`3I
Ool00`00Oomoo`0TOol001eoo`03001oogoo0=Uoo`03001oogoo02Aoo`007Goo00<007ooOol0fWoo
00<007ooOol08goo000MOol00`00Oomoo`3KOol00`00Oomoo`0ROol001eoo`03001oogoo0=]oo`03
001oogoo029oo`007Goo00<007ooOol0g7oo00<007ooOol08Goo000MOol00`00Oomoo`3MOol00`00
Oomoo`0POol001eoo`03001oogoo0=eoo`03001oogoo021oo`007Goo00<007ooOol0gWoo00<007oo
Ool07goo000MOol00`00Oomoo`3OOol00`00Oomoo`0NOol001eoo`03001oogoo0=moo`03001oogoo
01ioo`007Goo00<007ooOol0h7oo00<007ooOol07Goo000MOol00`00Oomoo`3QOol00`00Oomoo`0L
Ool001eoo`03001oogoo0>5oo`03001oogoo01aoo`007Goo00<007ooOol0hWoo00<007ooOol06goo
000MOol00`00Oomoo`3SOol00`00Oomoo`0JOol001eoo`03001oogoo0>=oo`03001oogoo01Yoo`00
7Goo00<007ooOol0i7oo00<007ooOol06Goo000MOol00`00Oomoo`3TOol00`00Oomoo`0IOol001eo
o`03001oogoo0>Eoo`03001oogoo01Qoo`007Goo00<007ooOol0iGoo00<007ooOol067oo000MOol0
0`00Oomoo`3VOol00`00Oomoo`0GOol001eoo`03001oogoo0>Ioo`03001oogoo01Moo`007Goo00<0
07ooOol0igoo00<007ooOol05Woo000MOol00`00Oomoo`3WOol00`00Oomoo`0FOol001eoo`03001o
ogoo0>Qoo`03001oogoo01Eoo`007Goo00<007ooOol0j7oo00<007ooOol05Goo000MOol00`00Oomo
o`3YOol00`00Oomoo`0DOol001eoo`03001oogoo0>Uoo`03001oogoo01Aoo`007Goo00<007ooOol0
jWoo00<007ooOol04goo000MOol00`00Oomoo`3ZOol00`00Oomoo`0COol001eoo`03001oogoo0>]o
o`03001oogoo019oo`007Goo00<007ooOol0jgoo00<007ooOol04Woo000MOol00`00Oomoo`3/Ool0
0`00Oomoo`0AOol001eoo`03001oogoo0>aoo`03001oogoo015oo`007Goo00<007ooOol0kGoo00<0
07ooOol047oo000MOol00`00Oomoo`3^Ool00`00Oomoo`0?Ool001eoo`03001oogoo0>ioo`03001o
ogoo00moo`007Goo00<007ooOol0kgoo00<007ooOol03Woo000MOol00`00Oomoo`3_Ool00`00Oomo
o`0>Ool001eoo`03001oogoo0?1oo`03001oogoo00eoo`007Goo00<007ooOol0l7oo00<007ooOol0
3Goo000MOol00`00Oomoo`3aOol00`00Oomoo`0<Ool001eoo`03001oogoo0?5oo`03001oogoo00ao
o`007Goo00<007ooOol0lWoo00<007ooOol02goo000MOol00`00Oomoo`3bOol00`00Oomoo`0;Ool0
01eoo`03001oogoo0?=oo`03001oogoo00Yoo`007Goo00<007ooOol0lgoo00<007ooOol02Woo000M
Ool00`00Oomoo`3dOol00`00Oomoo`09Ool001eoo`03001oogoo0?Aoo`03001oogoo00Uoo`007Goo
00<007ooOol0mGoo00<007ooOol027oo000MOol00`00Oomoo`3eOol00`00Oomoo`08Ool001eoo`03
001oogoo0?Ioo`03001oogoo00Moo`007Goo00<007ooOol0mWoo00<007ooOol01goo000MOol00`00
Oomoo`3gOol00`00Oomoo`06Ool001eoo`03001oogoo0?Moo`03001oogoo00Ioo`007Goo00<007oo
Ool0ogoo0Goo000MOol00`00Oomoo`3oOol1Ool001eoo`03001oogoo0?moo`5oo`007Goo00<007oo
Ool0ogoo0Goo000MOol00`00Oomoo`3oOol1Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {207.438, 0}} -> {-1.06982, 1.09606, \
0.00919736, 0.00919736}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(H = {Text[a1, {\(-0.4\), 1.15}]}\)], "Input"],

Cell[BoxData[
    \({Text[a1, {\(-0.4`\), 1.15`}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[G, Graphics[H]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .72381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.380952 -0.419048 0.380952 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .72531 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .11429 m
1 .11429 L
s
.1 0 m
.1 .72381 L
s
0 0 m
1 0 L
1 .72381 L
0 .72381 L
closepath
clip
newpath
.02381 .39736 m
.06244 .35491 L
.10458 .31499 L
.14415 .28315 L
.18221 .25735 L
.22272 .23481 L
.26171 .21765 L
.28158 .21056 L
.30316 .20411 L
.32216 .19947 L
.34309 .19548 L
.35264 .19405 L
.36292 .19278 L
.37378 .19174 L
.37905 .19134 L
.38395 .19104 L
.38884 .19081 L
.39135 .19071 L
.39406 .19063 L
.39561 .19059 L
.39703 .19055 L
.39837 .19053 L
.39984 .19051 L
.40116 .19049 L
.40239 .19048 L
.40369 .19048 L
.40442 .19048 L
.40509 .19048 L
.40633 .19048 L
.40765 .19049 L
.40878 .1905 L
.41003 .19051 L
.41136 .19053 L
.4128 .19056 L
.4154 .19062 L
.4205 .1908 L
.42518 .19102 L
.43498 .19168 L
.4441 .19251 L
.45411 .19368 L
.4648 .19522 L
.48615 .1992 L
.5063 .20409 L
.54476 .21649 L
.58568 .23425 L
.62509 .25598 L
.66297 .28139 L
.70331 .31357 L
.74214 .34989 L
.78341 .39467 L
Mistroke
.82317 .4443 L
.86142 .49857 L
.90212 .56396 L
.9413 .63504 L
.97619 .70568 L
Mfstroke
gsave
.25238 .01905 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{242.875, 175.75},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000[a000`40O003h00O67oo00<007ooOol0
egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol07Goo1@0000=o
o`0000000`00[goo000HOol00`00Oomoo`0MOol40004Ool00`00Oomoo`2_Ool001Qoo`03001oogoo
021oo`03001oogoo009oo`03001oogoo0:moo`0067oo00<007ooOol07Woo0`0017oo00<007ooOol0
[goo000HOol00`00Oomoo`0UOol00`00Oomoo`2_Ool001Qoo`03001oogoo02Aoo`800;5oo`0067oo
00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0
egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol0
0`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3G
Ool001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03
001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo0=Mo
o`0067oo00<007ooOol0egoo003b000001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000H
Ool00`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomo
o`3GOol001Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qo
o`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo
0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03001oogoo0=Moo`0067oo
00<007ooOol0egoo000HOol00`00Oomoo`0kOolG0025Ool001Qoo`03001oogoo03Ioo`D001Moo`H0
07moo`0067oo00<007ooOol0<Goo1@008Woo1@00NWoo000HOol00`00Oomoo`0]Ool4000/Ool4001f
Ool001Qoo`03001oogoo02]oo`8003Aoo`<007=oo`0067oo00<007ooOol09goo1000>Goo0`00L7oo
000HOol00`00Oomoo`0TOol30010Ool3001]Ool001Qoo`03001oogoo029oo`8004Ioo`8006]oo`00
67oo00<007ooOol087oo0P00BWoo0`00J7oo000HOol00`00Oomoo`0NOol2001?Ool2001VOol001Qo
o`03001oogoo01aoo`8005=oo`8006Aoo`0067oo00<007ooOol06Woo0P00Egoo0P00HWoo000HOol0
0`00Oomoo`0HOol2001KOol2001POol001Qoo`03001oogoo01Ioo`8005moo`03001oogoo05eoo`00
67oo00<007ooOol057oo0P00HWoo0P00GGoo000HOol00`00Oomoo`0BOol2001VOol2001KOol001Qo
o`03001oogoo015oo`03001oogoo06Qoo`03001oogoo05Qoo`0067oo00<007ooOol03goo0P00K7oo
0P00F7oo000HOol00`00Oomoo`0>Ool00`00Oomoo`1^Ool00`00Oomoo`1EOol001Qoo`03001oogoo
00aoo`80079oo`8005Eoo`0067oo00<007ooOol02goo00<007ooOol0M7oo00<007ooOol0DWoo000H
Ool00`00Oomoo`09Ool2001hOol2001BOol001Qoo`03001oogoo00Qoo`03001oogoo07Yoo`03001o
ogoo04moo`0067oo00<007ooOol01goo00<007ooOol0O7oo00<007ooOol0CWoo000HOol00`00Oomo
o`05Ool20020Ool00`00Oomoo`1=Ool001Qoo`03001oogoo00Aoo`03001oogoo085oo`03001oogoo
04aoo`0067oo00<007ooOol00goo00<007ooOol0Pgoo0P00C7oo000HOol00`00Oomoo`02Ool00`00
Oomoo`26Ool00`00Oomoo`19Ool001Qoo`03001oogoo008008Yoo`03001oogoo04Qoo`0067oo00<0
07oo0000SGoo00<007ooOol0Agoo000HOol2002?Ool00`00Oomoo`16Ool001Qoo`03001oogoo08mo
o`03001oogoo04Eoo`005goo0P00TWoo0P00AGoo000FOol00`00Ool0002DOol00`00Oomoo`12Ool0
01Eoo`04001oogoo002EOol00`00Oomoo`11Ool001=oo`8000=oo`03001oogoo09Aoo`03001oogoo
041oo`004Woo00<007ooOol00goo00<007ooOol0UGoo0P00@7oo000AOol00`00Oomoo`04Ool00`00
Oomoo`2GOol00`00Oomoo`0mOol0011oo`03001oogoo00Eoo`03001oogoo09Qoo`03001oogoo03ao
o`003goo00<007ooOol01Woo00<007ooOol0VGoo00<007ooOol0>goo000>Ool00`00Oomoo`07Ool0
0`00Oomoo`2JOol00`00Oomoo`0jOol000eoo`03001oogoo00Qoo`03001oogoo09]oo`03001oogoo
03Uoo`003Goo00<007ooOol027oo00<007ooOol0W7oo00<007ooOol0>7oo000<Ool00`00Oomoo`09
Ool00`00Oomoo`2MOol00`00Oomoo`0gOol000]oo`03001oogoo00Yoo`03001oogoo09eoo`03001o
ogoo03Moo`002Woo00<007ooOol02goo00<007ooOol0WWoo00<007ooOol0=Woo0009Ool00`00Oomo
o`0<Ool00`00Oomoo`2OOol00`00Oomoo`0eOol000Qoo`03001oogoo00eoo`03001oogoo0:1oo`03
001oogoo03Aoo`0027oo00<007ooOol03Goo00<007ooOol0XGoo00<007ooOol0<goo0007Ool00`00
Oomoo`0>Ool00`00Oomoo`2ROol00`00Oomoo`0bOol000Ioo`03001oogoo00moo`03001oogoo0:=o
o`03001oogoo035oo`0067oo00<007ooOol0Y7oo00<007ooOol0<7oo000HOol00`00Oomoo`2TOol0
0`00Oomoo`0`Ool001Qoo`03001oogoo0:Eoo`03001oogoo02moo`0067oo00<007ooOol0YWoo00<0
07ooOol0;Woo000HOol00`00Oomoo`2WOol00`00Oomoo`0]Ool001Qoo`03001oogoo0:Moo`03001o
ogoo02eoo`0067oo00<007ooOol0Z7oo00<007ooOol0;7oo000HOol00`00Oomoo`2YOol00`00Oomo
o`0[Ool001Qoo`03001oogoo0:Yoo`03001oogoo02Yoo`0067oo00<007ooOol0ZWoo00<007ooOol0
:Woo000HOol00`00Oomoo`2[Ool00`00Oomoo`0YOol001Qoo`03001oogoo0:aoo`03001oogoo02Qo
o`0067oo00<007ooOol0[7oo00<007ooOol0:7oo000HOol00`00Oomoo`2]Ool00`00Oomoo`0WOol0
01Qoo`03001oogoo0:ioo`03001oogoo02Ioo`0067oo00<007ooOol0[Woo00<007ooOol09Woo000H
Ool00`00Oomoo`2_Ool00`00Oomoo`0UOol001Qoo`03001oogoo0;1oo`03001oogoo02Aoo`0067oo
00<007ooOol0/Goo00<007ooOol08goo000HOol00`00Oomoo`2aOol00`00Oomoo`0SOol001Qoo`03
001oogoo0;9oo`03001oogoo029oo`0067oo00<007ooOol0/goo00<007ooOol08Goo000HOol00`00
Oomoo`2cOol00`00Oomoo`0QOol001Qoo`03001oogoo0;Aoo`03001oogoo021oo`0067oo00<007oo
Ool0]Goo00<007ooOol07goo000HOol00`00Oomoo`2eOol00`00Oomoo`0OOol001Qoo`03001oogoo
0;Ioo`03001oogoo01ioo`0067oo00<007ooOol0]goo00<007ooOol07Goo000HOol00`00Oomoo`2g
Ool00`00Oomoo`0MOol001Qoo`03001oogoo0;Qoo`03001oogoo01aoo`0067oo00<007ooOol0^7oo
00<007ooOol077oo000HOol00`00Oomoo`2iOol00`00Oomoo`0KOol001Qoo`03001oogoo0;Yoo`03
001oogoo01Yoo`0067oo00<007ooOol0^Woo00<007ooOol06Woo000HOol00`00Oomoo`2kOol00`00
Oomoo`0IOol001Qoo`03001oogoo0;aoo`03001oogoo01Qoo`0067oo00<007ooOol0_7oo00<007oo
Ool067oo000HOol00`00Oomoo`2mOol00`00Oomoo`0GOol001Qoo`03001oogoo0;eoo`03001oogoo
01Moo`0067oo00<007ooOol0_Woo00<007ooOol05Woo000HOol00`00Oomoo`2oOol00`00Oomoo`0E
Ool001Qoo`03001oogoo0;moo`03001oogoo01Eoo`0067oo00<007ooOol0`7oo00<007ooOol057oo
000HOol00`00Oomoo`30Ool00`00Oomoo`0DOol001Qoo`03001oogoo0<5oo`03001oogoo01=oo`00
67oo00<007ooOol0`Woo00<007ooOol04Woo000HOol00`00Oomoo`32Ool00`00Oomoo`0BOol001Qo
o`03001oogoo0<=oo`03001oogoo015oo`0067oo00<007ooOol0`goo00<007ooOol04Goo000HOol0
0`00Oomoo`34Ool00`00Oomoo`0@Ool001Qoo`03001oogoo0<Aoo`03001oogoo011oo`0067oo00<0
07ooOol0aGoo00<007ooOol03goo000HOol00`00Oomoo`36Ool00`00Oomoo`0>Ool001Qoo`03001o
ogoo0<Ioo`03001oogoo00ioo`0067oo00<007ooOol0agoo00<007ooOol03Goo000HOol00`00Oomo
o`37Ool00`00Oomoo`0=Ool001Qoo`03001oogoo0<Qoo`03001oogoo00aoo`0067oo00<007ooOol0
b7oo00<007ooOol037oo000HOol00`00Oomoo`39Ool00`00Oomoo`0;Ool001Qoo`03001oogoo0<Uo
o`03001oogoo00]oo`0067oo00<007ooOol0bWoo00<007ooOol02Woo000HOol00`00Oomoo`3:Ool0
0`00Oomoo`0:Ool001Qoo`03001oogoo0<]oo`03001oogoo00Uoo`0067oo00<007ooOol0bgoo00<0
07ooOol02Goo000HOol00`00Oomoo`3<Ool00`00Oomoo`08Ool001Qoo`03001oogoo0<aoo`03001o
ogoo00Qoo`0067oo00<007ooOol0cGoo00<007ooOol01goo000HOol00`00Oomoo`3=Ool00`00Oomo
o`07Ool001Qoo`03001oogoo0<ioo`03001oogoo00Ioo`0067oo00<007ooOol0cWoo00<007ooOol0
1Woo000HOol00`00Oomoo`3?Ool00`00Oomoo`05Ool001Qoo`03001oogoo0<moo`03001oogoo00Eo
o`0067oo00<007ooOol0d7oo00<007ooOol017oo000HOol00`00Oomoo`3@Ool00`00Oomoo`04Ool0
01Qoo`03001oogoo0=Moo`0067oo00<007ooOol0egoo000HOol00`00Oomoo`3GOol001Qoo`03001o
ogoo0=Moo`00\
\>"],
  ImageRangeCache->{{{0, 241.875}, {174.75, 0}} -> {-1.07038, 1.09606, \
0.0109179, 0.0109179}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<convexa.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 306, 5, 50, "Input"],
Cell[2048, 58, 8258, 192, 179, 1635, 106, "GraphicsData", "PostScript", \
"Graphics"],
Cell[10309, 252, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10476, 260, 60, 1, 30, "Input"],
Cell[10539, 263, 59, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10635, 269, 53, 1, 30, "Input"],
Cell[10691, 272, 9301, 227, 186, 2240, 135, "GraphicsData", "PostScript", \
"Graphics"],
Cell[19995, 501, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20162, 509, 73, 1, 30, "Input"],
Cell[20238, 512, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20405, 520, 299, 5, 50, "Input"],
Cell[20707, 527, 9715, 207, 217, 1571, 102, "GraphicsData", "PostScript", \
"Graphics"],
Cell[30425, 736, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30592, 744, 65, 1, 30, "Input"],
Cell[30660, 747, 64, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30761, 753, 53, 1, 30, "Input"],
Cell[30817, 756, 8996, 220, 184, 2176, 131, "GraphicsData", "PostScript", \
"Graphics"],
Cell[39816, 978, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39983, 986, 73, 1, 30, "Input"],
Cell[40059, 989, 130, 3, 29, "Output"]
}, Open  ]],
Cell[40204, 995, 26, 0, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

